!    User modul for unsaturated material (UNSAT) 
!    The only modifications brought to the User-ref are in Subroutines uRead, uCalVkc and uWriteGID
!    First worked with the version DISROC2D-17-0
!    Date 2026, January 18
!================================================================================
      Module uArrays
!     Here describe allocatable arrays to be shared with subroutines containing use uArrays

      integer :: i,j,k,n
!      double precision, allocatable :: bb(:,:)
!      integer, allocatable ::mmm(:)
!     
      EndModule uArrays
!================================================================================
!================================================================================
!================================================================================
!================================================================================
! 
      Module User
      use Tools
      Contains
!
!==============================================================
!--------------------------------------------------------------
      Subroutine uRead
      use Global; use uArrays; implicit none
!
!      NB(18) = 1  ! At least one material includes plasticity 
!      NB(23) = 1 ! At least one material includes viscous strain
!      NB(25)= 2 ! User defined volume forces in uForVol
      NB(41)=1 ! Variable hydraulic conductivity: rigidity matrix calculated every time step
      NB(42) =1 ! Variable hydraulic capacity: mass storage matrix calculated every time step
!      NB(77)=1  ! Activate Chemical calculation function
!      NB(78)=1 ! Variable thermal conductivity: rigidity matrix calculated every time step
!      NB(79) =1 ! Variable thermal capacity: matrix calculated every time step
!      NB(88) =1 ! Exist non linear elasticity or damage in user defined materials  
!      NB(94)=1 ! Chemical  Diffusitivity is variable
!      NB(95)=1 ! Chemical Storage coefficient is variable
!      NB(96)=1 ! Not any new mechanical load is added (after Resumption) 
!      NB(97)=1 ! Number of grains for the polycristal (used in ElementGrain and User) 
!      NB(104)= 1 ! Exist User-defined point loads (forces rates) (in uMechaHT)
!      NB(105)=3  ! Number of point loads
!      NB(107)= 1 ! Exist User-defined Internal Stress (in uSigInt) 
!      NB(109)= 1 ! Exist User-defined Free Strain (in uDefLib)
!      NB(111) = 1  ! Internal HM iteration process is acticvated
!      NB(116) = 1  ! Displacement remains continuous through joint elements
!      NB(121) = 1  ! Specific Mohr-Coulomb algorithm for anisotropic elasticity
!      NB(130)= 1 ! Exist User-defined source term for Hydraulic, uSrcH()
!      NB(138)= 1 ! M->H Coupling: 0 strain split without M->H Source Terms , =1 Stress split with S.T., =2 strain split with S.T.
!      NB(140)= 1 ! Output intermediate iteration states in graphical file 
!      NB(144)= 1, There exists user defined thermal source terms  
!	   NB(145)= 1 ! Chemical transport by advection taken into account. LUD system resolution method. 
!
      End Subroutine uRead
!==============================================================
!--------------------------------------------------------------
!##################    User Defined Process (Couplings) #########################
!==============================================================
!      Before starting Hydro-Thermo-Mechanical loop
!--------------------------------------------------------------
      Subroutine uInit
      use Global;use uArrays; implicit none
!      Describe here the complementary initialization commands
!
!     Call Readcontour(1)
!     do k=1,NB(26); print*, k, (konb(k,i),i=1,3); enddo
!      allocate(Satur(NB(2))
!      do n=1, NB(2); Satur(n)=1.D0-Vinh(n,1); enddo
      
      End Subroutine uInit
!
!==============================================================
!      Before starting Hydro-Thermo-Mechanical loop
!--------------------------------------------------------------
      Subroutine uCycleEntry
      use Global; use uArrays; implicit none
!      Describe here what should be down at each time increment before calculation of the next increment 
!
      End Subroutine uCycleEntry
!
!==============================================================
!      Coupling from Hydraulic to Thermal and Mechanics
!--------------------------------------------------------------
      Subroutine uHydroTM
      use Global; use uArrays; implicit none
!      Describe here the effect of Hydraulic variables on the Thermal and Mechical processes
!
      End Subroutine uHydroTM
!
!==============================================================
!      Coupling from Thermal to Mechanics and Hydraulic
!--------------------------------------------------------------
      Subroutine uThermoMH
      use Global; use uArrays; implicit none
!      Describe here the effect of Thermal variables on the Mechical and Hydraulic processes
!
      End Subroutine uThermoMH
!==============================================================
!      Coupling from Mechanics to Hydraulic and Thermal
!--------------------------------------------------------------
      Subroutine uMechaHT
      use Global; use uArrays; implicit none
!      Describe here the effect of Mechanical variables on the Hydraulic and Thermal processes
!
      End Subroutine uMechaHT
!==============================================================
!      Coupling from Chemical to Hydraulic and Thermal and Mechanics
!--------------------------------------------------------------
      Subroutine uChemoHTM
      use Global; use uArrays; implicit none
!      Describe here the effect of Chemical variables changes on the Hydraulic, Thermal and Mechanical processes
!
      End Subroutine uChemoHTM
!==============================================================
!      After Hydro-Thermo-Mechanical is finished
!--------------------------------------------------------------
      Subroutine uWriteF
      use Global; use uArrays; implicit none
!      Describe here the complementary commands before leaving the process
!
      End Subroutine uWriteF
!
!==============================================================
!--------------------------------------------------------------
!##################    User Defined Models  #####################################
!==============================================================
!     Subroutine for defining material's damage criterion
!--------------------------------------------------------------
      Subroutine uCalCrit(nn,matn,modmatn,sxyl,f0)
      use Global; implicit none
      integer :: nn,matn, modmatn
      double precision :: sxyl(NB(28)), f0
!-----------------------------------------------  
       f0=0.D0; sxyl(1)=sxyl(1); modmatn=modmatn; matn=mat(nn)
       goto 1000
!      if (modmatn.eq.91130) then
!       f0=0.D0; Vinm(nn,0)=f0
!       goto 1000 
!       endif
1000    Continue
        end Subroutine uCalCrit
!==============================================================
!     Subroutine for defining material's elastic tensor
!--------------------------------------------------------------
      Subroutine ucalCmat(nn,matn,modmatn,C)
      use Global; implicit none
!      character ch
      integer :: nn,matn, modmatn
      double precision C(NB(28),NB(28))
!      double precision :: xfact,EY, XNU
!      double precision :: ALPHA,D, XD, beta, sigR, sigPc, tau0, sigman0,tanfi,Coh,f0
!-----------------------------------------------  
      goto 1000 
       matn=mat(nn)
       if (modmatn.eq.91130) then
        C(1,1)=vmat(matn,1,1); C(2,2)=vmat(matn,1,2)
        C(1,2)=vmat(matn,1,3); C(2,1)=C(1,2)
        goto 1000 
       endif
       goto 1000
!       print*, 'Error1 materiau; element, mat, modmat: ', nn,matn, modmatn
!       stop
!510   continue ; ! Linear and isotropic elastic material	   
!       EY=vmat(mat(nn),1,1); XNU=vmat(mat(nn),1,2); xfact = EY/((1+XNU)*(1-2*XNU))
!          C(1,1)=1-XNU;  C(1,2)=XNU;  C(1,3)=XNU; C(1,4) =0.D0
!          C(2,1)= XNU;  C(2,2)=1-XNU;  C(2,3)=XNU; C(2,4) =0.D0
!          C(3,1)= XNU;  C(3,2)= XNU;  C(3,3)=1-XNU; C(3,4) =0.D0
!          C(4,1)= 0.D0;  C(4,2)= 0.D0;  C(4,3)=0.D0; C(4,4) =(1-2*XNU)/2.D0
!          Do i=1, 4; do j=1, 4; C(i,j) = xfact*C(i,j); enddo; Enddo
!      GOTO 1000
!
      goto 1000 
!
1000    Continue
        end Subroutine ucalCmat
!==============================================================
!     Subroutine for defining plastic strain
!--------------------------------------------------------------
      Subroutine udefplas(nn,matn,modmatn,CC,SXYL,iter,fNmax)
!	
      use Global; implicit none
      double precision :: CC(NB(28),NB(28)), SXYL(NB(28)), dFdsig(NB(28))
    ! general variables 
      integer :: i, nn, matn, modmatn, ia, ib, ndimC, iter
      double precision gama, Gkapa, rI1, rJ2, f0, h, xlam, fNmax, epsp
!
       Goto 10000
      if (iter<2) write(*, '(a,I5)') 'Iter :',iter
      epsp=var(3)
!-----------
       if (modmatn.eq.91110) then
        gama = vmat(matn,1,7); Gkapa = vmat(matn,1, 8); goto 520
       endif
       goto 10000
520    Continue ; ! Elastoplasti Drucker-Prager Material  given for example
       ndimC = 4
       rI1 = sxyl(1)+sxyl(2)+sxyl(3)
       rJ2 = sqrt((sxyl(1)**2+sxyl(2)**2+sxyl(3)**2+2*sxyl(4)**2-rI1*rI1/3)/2)
       f0 = gama*rI1 +rJ2-Gkapa; if (f0/Gkapa.gt.fNmax) fNmax = f0/Gkapa
       if (f0.gt.0.) then
        do i = 1, 3; dFdsig(i) = gama +(sxyl(i)-rI1/3)/2/rJ2; enddo
        dFdsig(4) = sxyl(4)/rJ2 ;! multiple par deux car epsil4=2*epsilonxy
        H = 0.
        Do ia=1,ndimC; do ib = 1, ndimC; H = H + dFdsig(ia)*CC(ia, ib)*dFdsig(ib); enddo; Enddo
        xlam = f0/H
        Do ia = 1, ndimC; dEp(nn,ia) =xlam*dFdsig(ia); Enddo
       endif
       Goto 10000
!
10000  Continue
       end Subroutine udefplas
!==============================================================
!     Subroutine for defining viscous strain
!--------------------------------------------------------------
      Subroutine udefvis(nn,matn,modmatn)
      use Global; use uArrays; implicit none
      integer :: nn, matn, modmatn
!      character(len=80) :: fich
!      double precision bt,bn,qn,alfa,xsitp,xsinp,xalt,xaln,s1,s2,deltat,xsimin,epsmin
!
      nn=nn; matn=matn; modmatn=modmatn
      
      goto 1000
!---------------------------------------
!
1000  Continue
      end Subroutine udefvis
!==============================================================
!     Subroutine for defining Free Strain
!--------------------------------------------------------------
       Subroutine uDefLib
      use Global; use uArrays; implicit none
!      character(len=80) :: fich
!      integer :: n, j, matn, modmatn, ndimC
!      double precision const  
       goto 1000  ! Remove this line before programming
!==========  
!      dEPL(:,:)=0.D0
!============================================================
!      Do n=1,NB(2)
!     if (modmatn.eq.943000) then
!  Calcul de defrmation de gonflement
!      ndimC = nodgaus(ntyp(n),3)
!      do j=1, ndimC; dEPL(n,j)=const*(RPg(n)-RPga(n)); enddo
!      Enddo 
!
1000  Continue
      end Subroutine uDefLib
!==============================================================
!     Subroutine for defining volume forces
!     To activate this subroutine, put NB(25)=2 in uRead
!--------------------------------------------------------------
      Subroutine uForVol  
      use Global; implicit none
!      character(len=80) :: fich
!       integer :: n, ia, j, ng, matn, modmatn
      goto 1000
1000  Continue
      end Subroutine uForVol
!
!==============================================================
!     Subroutine for defining Initial Stresses
!     Activate NB(107) = 1 in uRead to this subroutine be called
!--------------------------------------------------------------
      Subroutine uSigInt
      use Global; implicit none
!
!     dSXYi(:,:) = ...
!
      end Subroutine uSigInt
!
!================================================================================
!     Subroutine for defining Hydraulic diffusion parameters
!     VVK(i,j)-> VK(nn,i,j),   Storg -> CStorg(nn) ,  cnf -> Vcnf(nn) (See Scientific Manual)
!--------------------------------------------------------------------------------
      Subroutine uCalVkc(nn,VVK,Storg,Cnf)
      use Global; use uArrays; implicit none 
      double precision :: VVK(2,2), Storg,Cnf      
      integer :: nn, mtn, modcod
      double precision :: Kinmu,relk,sat,sm,vm,vn,alfa,dsp,Kf,Phi
!
       n=nn; mtn=mat(n); modcod=modmat(mat(n),2,3)   
       If (modcod.eq.3212) Then  ! material UNSAT
        Kinmu=vmat(mtn,2,1); Phi=vmat(mtn,2,2); Kf=vmat(mtn,2,3)
        sm=vmat(mtn,2,4); vm=vmat(mtn,2,5); vn=vmat(mtn,2,6); alfa=vmat(mtn,2,7)
        if (RPg(n).ge.0.D0) then
         sat=1.D0; dsp=0.D0
        else
         sat = (1.D0+(-alfa*RPg(n))**vn)**vm; sat=1.D0/sat
         dsp=-vm*vn*sat*(1.D0-sat**(1.D0/vm))/RPg(n)     ! dsp = dS /dp
        endif
        relk=dsqrt(sat)*(1.D0-(1.D0-sat**(1.D0/sm))**sm)**2.D0    ! relative permeability
        relk=0.0001D0+0.9999D0*relk  ! lower limit to avoid numerical problems due to zer permeability
        VVK(1,1)=Kinmu*relk; VVK(2,2)=VVK(1,1); VVK(1,2)=0.D0; VVK(2,1)= 0.D0    ! 2x2 permeability tensor
        Storg=Phi*((sat/Kf)+dsp)     ! Storage coefficient
        Cnf=0.D0    !   concerns joints and not surface elements
        Vinh(n,1)=1.D0-sat
       Endif
      end Subroutine uCalVkc
!
!================================================================================
!     Subroutine for defining Thermal diffusion parameters
!     qKTh(i,j)-> Qk(nn,i,j),   Cthn -> QCth(nn) ,  cinfn -> Qcinf(nn) (See Scientific Manual)
!--------------------------------------------------------------------------------
      Subroutine uCalQkc(nn,qKTh,Cthn,cinfn)
      use Global; use uArrays; implicit none 
      double precision qKTh(2,2), Cthn,cinfn
      integer :: nn
!
      nn=nn; qKTh(1,1)=qKTh(1,1); Cthn=Cthn; Cinfn=Cinfn
!      modmatn=modmat(mat(nn),3,3)   
!     if (modmatn.eq.95050) then
!      qKTh(1,1)=1.;  qKTh(2,2)=1.;  qKTh(1,2)=0.;  qKTh(2,1)=0.;
!      Cthn=1.; cinfn=0.
!     endif
      end Subroutine uCalQkc
!
!================================================================================
!     Subroutine for defining chemical process parameters
!--------------------------------------------------------------------------------
      Subroutine uDphyC
      use Global; use uArrays; implicit none
      integer mtn
!
!   Debut intervention--------------
       Do n=1,NB(2); mtn=mat(n)   
!       if (modmat(mtn,2,1).eq.32100) goto 92100
!       if (matname(mtn)=="CLAY") goto 92100
!       if (modmat(mtn,1,1).eq.921300) goto 93100
       goto 1000
!       
!92100 Continue; ! Element joint
       Difc(n,1,1)=1.0;Difc(n,2,2)=Difc(n,1,1);Difc(n,1,2)=0.0;Difc(n,2,1)=Difc(n,1,2);srcC(n)=1.0; asrcC(n)= 0.1
       PhyC(n) = 1; !  PhyC(n) = vmat(mtn,3,11); RhoC(n)=1.D0
       goto 1000
!93100 Continue; ! Element massif
!       Difc(n,1,1)=1.0;Difc(n,2,2)=2.0;Difc(n,1,2)=0.0;Difc(n,2,1)=Difc(n,1,2);srcC(n)=1.0; asrcC(n)= 0.1
!        PhyC(n) = vmat(mtn,6); RhoC(n)=1.D0
      goto 1000
!     
1000   Continue
      Enddo
      end Subroutine uDphyC
!================================================================================
!     Subroutine to create time-evolution plots
!--------------------------------------------------------------------------------
      Subroutine uCurve(m)
      use Global; use uArrays; implicit none
      character(len=90) :: Fich1
!      double precision :: ux, uy
      integer m, nbdl, n1, n2
!
      nbdl=NB(10)
!    ----------------   m=1    Opening the file et writing title line      
      if (m.gt.1) goto 105  
      Fich1 = trim(foldername)//"\Uplot.dat"
      open (unit=21, file=Fich1, status='replace')
      write(21,*) 't, Ux(n1), Uy(n2) , Sig_xx(n2)'
105   continue
!    ----------------  m=2   Writing for the time t   
       n1 = 1; n2=3
     write(21,305) Temps, RU(n1,1),RU(n1,2), SXY(n2,1)
!    ----------------  m=3   Closing the file
      if (m.eq.3) close(21)
!    Formats ----------------- 
305   Format (15(1X,E14.7))
!1000  Continue
      end Subroutine uCurve
!
!==============================================================
!  Subroutine for completing the post-process output file
!--------------------------------------------------------------
      Subroutine uWriteGID
      use Global; use uArrays; implicit none
      double precision :: TimeG
!      double precision EPnod(NB(1)),EPval
!      double precision nx, ny, sigL,sxynod(NB(1),4)
!      integer :: i, n, nj, j , n1, n2, kj, njb
!
!       TimeG=Temps+var(31)  modified
       TimeG=Temps+var(35)
!      Goto 1000
!------------
!      if ((NB(8)+NB(9)+NB(65)).eq.0) goto 50
!      write(17,*) 'Result "Joint active" "analysis name" ', TimeG, '  Scalar OnGausspoints "joints"'
!      write(17,*) 'ComponentNames "RetN"'
!      write(17,*) 'Values'
!      DO n=1,NB(2)
!       If ((ntyp(n).eq.5).or.(ntyp(n).eq.6).or.(ntyp(n).eq.8)) then
!        write(17,*) n, nretm(n)
!       Endif
!      ENDDO
!      write(17,*) 'end values'
!50   Continue
!------------
!      if ((NB(8)+NB(9)+NB(65)).eq.0) goto 150
!      write(17,*) 'Result "Joint Stress (E)" "analysis name" ', TimeG, '  Vector OnGausspoints "joints"'
!      write(17,*) 'ComponentNames "Tau","Sn", "|Tau|"'
!      write(17,*) 'Values'
!      DO n=1,NB(2)
!      If ((ntyp(n).eq.5).or.(ntyp(n).eq.6).or.(ntyp(n).eq.8)) then
!       write(17,*) n, SXY(n,1), SXY(n,2), abs(SXY(n,1))
!      Endif
!      ENDDO
!      write(17,*) 'end values'
!150   Continue
!------------
!      If ((NB(5)+NB(9)+NB(61)+NB(65)).ne.0) then      
!      write(17,*) 'Result "Bar Force Vector (E)" "analysis name" ', TimeG, '  Vector OnGaussPoints "Bars"'
!      write(17,*) 'ComponentNames "SLx","SLy"'
!      write(17,*) 'Values'
!      do n=1,NB(2)    
!       n1 = konec(n,1); n2 = konec(n,2)
!       nx = -(x(n2,2)-x(n1,2))/S(n); ny = (x(n2,1)-x(n1,1))/S(n)
!      if ((ntyp(n).eq.2).or.(ntyp(n).eq.7)) write(17,*) n, SXY(n,1)*nx,SXY(n,1)*ny
!      if ((ntyp(n).eq.6).or.(ntyp(n).eq.8)) write(17,*) n, SXY(n,3)*nx,SXY(n,3)*ny
!      end do
!      write(17,*) 'end values'
!      Endif
!------------
!      write(17,*) 'Result "Fluid Pressures (N)" "analysis name" ',TimeG,' Scalar OnNodes'
!      write(17,*) 'ComponentNames "Fluid Pressure"'; write(17,*) 'Values'
!      do i=1,NB(1); write(17,*) i, RP(i); end do
!      write(17,*) 'end values'
!------------
!      write(17,*) 'Result "Fluid Velocity (N)" "analysis name" ',TimeG,' Vector OnNodes'
!      write(17,*) 'ComponentNames "Vx","Vy"'; write(17,*) 'Values'
!      do i=1,NB(1); write(17,*) i, VXY(i,1), VXY(i,2); end do
!      write(17,*) 'end values'
!------------
!       write(17,*) 'Result "Irreversible Strain Norm (E)" "analysis name" ', TimeG, '  Scalar OnGaussPoints "Qtriang"'
!       write(17,*) 'ComponentNames "Eir"'
!       write(17,*) 'Values'
!       do n=1,NB(2)
!        if ((ntyp(n).eq.3).or.(ntyp(n).eq.4)) then
!         EPVal=sqrt(Eir(n,1)**2+Eir(n,2)**2+Eir(n,3)**2+0.5*Eir(n,4)**2)
!         write(17,*) n, EPVal
!        endif
!       end do
!       write(17,*) 'end values'
!------------
       write(17,*) 'Result "Saturation degree" "analysis name" ', TimeG, '  Scalar OnGaussPoints "Qtriang"'
       write(17,*) 'ComponentNames "Sat"'
       write(17,*) 'Values'
       do n=1,NB(2)
        if ((ntyp(n).eq.3).or.(ntyp(n).eq.4)) then
         write(17,*) n, 1.D0-Vinh(n,1)
        endif
       end do
       write(17,*) 'end values'
!------------
!      write(17,*) 'Result "Fluid Velocities (E)" "analysis name" ', TimeG, '  Vector OnGaussPoints "Qtriang"'
!      write(17,*) 'ComponentNames "Vx", "Vy"'; write(17,*) 'Values'
!      do n=1,NB(2)
!       if ((ntyp(n).eq.3).or.(ntyp(n).eq.4)) then 
!        write(17,*) n,VXYL(n,1),VXYL(n,2)
!       endif 
!      end do
!      write(17,*) 'end values'
!------------
!1000   Continue
      end Subroutine uWriteGID
!=============================================================
!    Subroutine to show how works the Subroutine Vsort for sorting a table in increasing order
!-------------------------------------------------------------
!    Minax(n) provides the initial position of the n-th rank if sorted in increasing order
      Subroutine ExampleSort
      implicit none
      integer, allocatable :: minax(:)
      double precision, allocatable :: sc(:)
      integer :: nbv,i
!
      nbv=5   ! Array dimension
      ! if (allocated(sc)) deallocate (sc, minax)
      allocate (sc(nbv), minax(nbv))
      sc(1)=1.3; sc(2)=1.5; sc(3)=0.3; sc(4)=2.3; sc(5)=2.0
      print*, (sc(i), i=1,nbv)    !  -->  1.3, 1.5, 0.3, 2.3, 2.0
      call VSort(nbv,sc,minax)
      print*, (sc(minax(i)), i=1,nbv)    !  -->  0.3, 1.3, 1.5, 2.0, 2.3
      END subroutine ExampleSort
!
!================================================================================
!--------------------------------------------------------------------------------
!
      End Module User
